<?php
    /**
    *
    * copyright (c) 2013-2023 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/articolo.php?id=34&alias=linee-guida-per-l%27uso-del-logo-geecom
    */

    class VisualizzatoreProfili extends VisualizzatoreComponente {

        private $aspectRatio;
        
        function __construct($db) {
            parent::__construct($db);
            $this->aspectRatio = "";
        }
        
        function generaContenutoSezione($dati) {
            $preferenze        = parent::getDb()->leggiSingolaRiga("geec_visualizzatoriProfili",$dati["idElemento"]);
            $this->aspectRatio = $preferenze["aspectRatio"];
            echo"<div class=\"{$preferenze["spazioOccupato"]}\">
                    <div class=\"row profili\">";
                        if($preferenze["aspetto"]=="tradizionale") {
                            $this->stampaProfili($dati);
                        }
                        else {
                            $this->stampaProfiliSlider($dati);
                        }
                echo"</div>
                </div>";
        }
        
        function stampaProfili($dati) {
            $queryProfili = "SELECT * FROM geec_profili WHERE idVisualizzatoreProfili = {$dati["idElemento"]} ORDER BY posizione ASC";
            $risTabelle = parent::getDb()->eseguiQueryLettura($queryProfili);
            while($profilo = $risTabelle->fetch_assoc()) {
                $this->stampaProfilo($profilo);
            }
        }
        
        function stampaProfiliSlider($dati) {
            echo"<div class=\"col\">
                    <div id=\"profili\" class=\"owl-carousel owl-theme\">";                            
                    $queryProfili = "SELECT * FROM geec_profili WHERE idVisualizzatoreProfili = {$dati["idElemento"]} ORDER BY posizione ASC";
                    $risTabelle = parent::getDb()->eseguiQueryLettura($queryProfili);
                    while($profilo = $risTabelle->fetch_assoc()) {
                        $this->stampaProfiloSlider($profilo);
                    }
                echo"</div>
                </div>";
        }
        
        function stampaProfiloSlider($profilo) {
            if($profilo["immagine"]!="") {
                $percorsoImmagine = $profilo["immagine"];
            }
            else {
                $percorsoImmagine = "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcTRKeKUx-a7MxxeBRO1_raaQ9465EiNyTfsfrKeR2_8xZBBodcGew";
            }
            echo"<div class=\"card box-shadow-lite mb-4 w-100\">
                    <div class=\"$this->aspectRatio border-0\">
                        <img class=\"img-fluid background-image mx-auto border-0\" style=\"background-image: url('$percorsoImmagine')\">
                    </div>
                    <div class=\"text-center mt-3\">
                        <strong>{$profilo["nome"]}</strong>
                        <footer class=\"blockquote-footer\">{$profilo["ruolo"]} <cite> {$profilo["azienda"]} </cite></footer>";

                        echo"<div class=\"m-3 text-left\">{$profilo["descrizione"]}</div>";
                        $this->stampaLinkSocial($profilo);
                    echo"</div>
                </div>";
        }
        
        function stampaProfilo($profilo) {
            if($profilo["immagine"]!="") {
                $percorsoImmagine = $profilo["immagine"];
            }
            else {
                $percorsoImmagine = "immagini/altro/segnaposto.png";
            }
            
            echo"<div class=\"col-sm-6 col-lg-4 mx-auto d-flex align-items-stretch\">
                    <div class=\"card box-shadow-lite mb-4 w-100\">
                        <div class=\"$this->aspectRatio border-0\">
                            <img class=\"img-fluid background-image mx-auto border-0\" style=\"background-image: url('$percorsoImmagine')\">
                        </div>
                        <div class=\"text-center mt-3\">
                            <strong>{$profilo["nome"]}</strong>
                            <footer class=\"blockquote-footer\">{$profilo["ruolo"]} <cite> {$profilo["azienda"]} </cite></footer>";

                            echo"<div class=\"m-3 text-left\">{$profilo["descrizione"]}</div>";
                            $this->stampaLinkSocial($profilo);
                        echo"</div>
                    </div>
                </div>";
        }
        
        function stampaLinkSocial($profilo) {
            echo"<ul class=\"list-inline my-3\">";
                if($profilo["facebook"]!="") {
                    echo"<li class=\"list-inline-item\"><a href=\"{$profilo["facebook"]}\"><i class=\"fab fa-facebook-square\"></i></a></li>";
                }
                if($profilo["twitter"]!="") {
                    echo"<li class=\"list-inline-item\"><a href=\"{$profilo["twitter"]}\"><i class=\"fab fa-twitter-square\"></i></a></li>";
                }
                if($profilo["linkedin"]!="") {
                    echo"<li class=\"list-inline-item\"><a href=\"{$profilo["linkedin"]}\"><i class=\"fab fa-linkedin\"></i></a></li>";
                }   
                if($profilo["instagram"]!="") {
                    echo"<li class=\"list-inline-item\"><a href=\"{$profilo["instagram"]}\"><i class=\"fab fa-instagram\"></i></a></li>";
                }  
                if($profilo["email"]!="") {
                    echo"<li class=\"list-inline-item\"><a href=\"mailto:{$profilo["email"]}\"><i class=\"fas fa-envelope\"></i></a></li>";
                }  
            echo"</ul>";
        }
        function getJavascriptAssociato() {
            return "<script src=\"plugins/OwlCarousel2/owl.carousel.min.js\"></script>
                    <script type=\"text/javascript\">
                        $('#profili').owlCarousel({
                        loop:false,
                        margin:10,
                        nav:false,
                        responsive:{
                          0:{
                            items:1
                          },
                          600:{
                            items:2
                          },
                          1000:{
                            items:3
                          }
                        }
                      })
                </script>";
        }
    }